/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.util;

import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.client.ModSounds;
import com.alcatrazescapee.notreepunching.common.items.ModItems;
import com.alcatrazescapee.notreepunching.util.Util;
import com.alcatrazescapee.notreepunching.util.WoodRecipeHandler;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public final class PlayerInteractionHandler {
    public static boolean hasAction(World world, BlockPos pos, ItemStack stack, @Nullable EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        if (stack.func_77973_b() == Items.field_151145_ak) {
            return ModConfig.BALANCE.flintKnappingChance > 0.0 && state.func_185904_a() == Material.field_151576_e && state.func_185915_l() && face == EnumFacing.UP;
        }
        if (WoodRecipeHandler.isAxe(stack)) {
            IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
            if (face == EnumFacing.UP && stateDown.func_185914_p()) {
                return WoodRecipeHandler.isLog(world, pos, state) && !WoodRecipeHandler.isLog(world, pos.func_177977_b(), stateDown) || WoodRecipeHandler.isPlank(world, pos, state);
            }
        }
        return false;
    }

    public static boolean performAction(World world, BlockPos pos, EntityPlayer player, ItemStack stack, @Nullable EnumFacing face, EnumHand hand) {
        if (stack.func_77973_b() == Items.field_151145_ak) {
            return PlayerInteractionHandler.handleFlint(world, pos, player, stack, hand);
        }
        if (WoodRecipeHandler.isAxe(stack)) {
            return PlayerInteractionHandler.handleChopping(world, pos, player, stack);
        }
        return false;
    }

    private static boolean handleFlint(World world, BlockPos pos, EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (!world.field_72995_K) {
            if ((double)Util.RNG.nextFloat() < ModConfig.BALANCE.flintKnappingChance) {
                if ((double)Util.RNG.nextFloat() < ModConfig.BALANCE.flintKnappingSuccessChance) {
                    CoreHelpers.dropItemInWorldExact((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)(pos.func_177956_o() + 1), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)new ItemStack(ModItems.FLINT_SHARD, 2));
                }
                player.func_184611_a(hand, CoreHelpers.consumeItem((EntityPlayer)player, (ItemStack)stack));
            }
            world.func_184133_a(null, pos, ModSounds.KNAPPING, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    private static boolean handleChopping(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K) {
            if ((double)Util.RNG.nextFloat() < ModConfig.BALANCE.logChoppingChance) {
                IBlockState state;
                ItemStack result;
                int amount = 1 + ((double)Util.RNG.nextFloat() < 0.75 ? 1 : 0);
                if (!WoodRecipeHandler.isWeakAxe(stack)) {
                    ++amount;
                }
                if ((result = WoodRecipeHandler.getPlankForLog(world, pos, state = world.func_180495_p(pos))) != null) {
                    result.func_190920_e(amount);
                    CoreHelpers.dropItemInWorldExact((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)(pos.func_177956_o() + 1), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)result);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    world.func_175698_g(pos);
                } else if (WoodRecipeHandler.isPlank(world, pos, state)) {
                    result = new ItemStack(Items.field_151055_y, 1 + ((double)Util.RNG.nextFloat() < 0.25 ? 1 : 0));
                    CoreHelpers.dropItemInWorldExact((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)(pos.func_177956_o() + 1), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)result);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    world.func_175698_g(pos);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187881_gQ, SoundCategory.PLAYERS, 1.2f, 1.0f);
            } else {
                world.func_184133_a(null, pos, SoundEvents.field_187881_gQ, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
        return true;
    }
}

